﻿#Make sure you are connected to the EXO of the customer

#or
#Connect-ExchangeOnline

## Sophos Transport Rules to bypass Quarantine.

New-TransportRule -Name 'Sophos-Bypass Clutter & Spam Filtering by IP Address' -SenderIpRanges @('54.240.51.53', '54.240.51.52') -SetHeaderName 'X-MS-Exchange-Organization-BypassClutter' -SetHeaderValue 'true' -SetSCL '-1' -StopRuleProcessing:$false -Mode 'Enforce' -Comments '' -RuleErrorAction 'Ignore' -SenderAddressLocation 'Header'
New-TransportRule -Name 'Sophos-Bypass the Junk Folder by IP Address' -SenderIpRanges @('54.240.51.53', '54.240.51.52') -SetHeaderName 'X-Forefront-Antispam-Report' -SetHeaderValue 'SFV:SKI;' -StopRuleProcessing:$false -Mode 'Enforce' -Comments '' -RuleErrorAction 'Ignore' -SenderAddressLocation 'Header'
New-TransportRule -Name 'Sophos-Bypass Safe Links Processing by IP Address' -SenderIpRanges @('54.240.51.53', '54.240.51.52') -SetHeaderName 'X-MS-Exchange-Organization-SkipSafeLinksProcessing' -SetHeaderValue '1' -StopRuleProcessing:$false -Mode 'Enforce' -Comments '' -RuleErrorAction 'Ignore' -SenderAddressLocation 'Header'
New-TransportRule -Name 'Sophos-Bypass Safe Attachments Processing by IP Address' -SenderIpRanges @('54.240.51.53', '54.240.51.52') -SetHeaderName 'X-MS-Exchange-Organization-SkipSafeAttachmentProcessing' -SetHeaderValue '1' -StopRuleProcessing:$false -Mode 'Enforce' -Comments '' -RuleErrorAction 'Ignore' -SenderAddressLocation 'Header'


## Sophos Safe Links Bypass

[array]$ExcludedUrls = @(
'*.go-vip.co/*', 
'*.voicemailbox.online/*',
'*.trackshipping.online/*',
'*.toll-citations.com/*',
'*.tax-official.com/*',
'*.shipping-updates.com/*',
'*.secure-bank-alerts.com/*',
'*.outlook-mailer.com/*',
'*.online-statements.site/*',
'*.myhr-portal.site/*',
'*.mail-sender.online/*',
'*.linkedn.co/*',
'*.it-supportdesk.com/*',
'*.hr-benefits.site/*',
'*.helpdesk-tech.com/*',
'*.gmailmsg.com/*',
'*.global-hr-staff.com/*',
'*.fakebookalerts.live/*',
'*.epromodeals.com/*',
'*.e-receipts.co/*',
'*.e-faxsent.com/*',
'*.e-documentsign.com/*',
'*.e-billinvoices.com/*',
'*.court-notices.com/*',
'*.corporate-realty.co/*',
'*.buildingmgmt.info/*',
'*.bankfraudalerts.com/*',
'*.auditmessages.com/*',
'*.awstrack.me/*',
'*.sophos.com/*'
)

$Var = Get-SafeLinksPolicy

$Var.Name

## Add Url Exclusions
foreach($Url in $ExcludedUrls){
    Set-SafeLinksPolicy -Identity "Safe Links Baseline Policy" -DoNotRewriteUrls @{Add=$Url}
}

$Var = "Safe Links Baseline Policy"
$Var.DoNotRewriteUrls


## Sophos Phish Policy Exclusion

[array]$ExcludedUrls = @(
'go-vip.co', 
'voicemailbox.online',
'trackshipping.online',
'toll-citations.com',
'tax-official.com',
'shipping-updates.com',
'secure-bank-alerts.com',
'outlook-mailer.com',
'online-statements.site',
'myhr-portal.site',
'mail-sender.online',
'linkedn.co',
'it-supportdesk.com',
'hr-benefits.site',
'helpdesk-tech.com',
'gmailmsg.com',
'global-hr-staff.com',
'fakebookalerts.live',
'epromodeals.com',
'e-receipts.co',
'e-faxsent.com',
'e-documentsign.com',
'e-billinvoices.com',
'court-notices.com',
'corporate-realty.co',
'buildingmgmt.info',
'bankfraudalerts.com',
'auditmessages.com',
'awstrack.me',
'sophos.com'
)

$Var2 = Get-AntiPhishPolicy

$Var2.Name

## Add domain Exclusions
foreach($Url in $ExcludedUrls){
    Set-AntiPhishPolicy -Identity ($Var2.Name) -ExcludedDomains @{Add=$Url}
}
## Add email Exclusions
Set-AntiPhishPolicy -Identity ($Var2.Name)-ExcludedSenders training@staysafe.sophos.com

## AntiSpam Baseline Policy Policy Exclusion

[array]$ExcludedUrls = @(
'go-vip.co', 
'voicemailbox.online',
'trackshipping.online',
'toll-citations.com',
'tax-official.com',
'shipping-updates.com',
'secure-bank-alerts.com',
'outlook-mailer.com',
'online-statements.site',
'myhr-portal.site',
'mail-sender.online',
'linkedn.co',
'it-supportdesk.com',
'hr-benefits.site',
'helpdesk-tech.com',
'gmailmsg.com',
'global-hr-staff.com',
'fakebookalerts.live',
'epromodeals.com',
'e-receipts.co',
'e-faxsent.com',
'e-documentsign.com',
'e-billinvoices.com',
'court-notices.com',
'corporate-realty.co',
'buildingmgmt.info',
'bankfraudalerts.com',
'auditmessages.com',
'awstrack.me',
'sophos.com'
)

Get-HostedContentFilterPolicy

## Add domain Exclusions
foreach($Url in $ExcludedUrls){
    Set-HostedContentFilterPolicy -Identity "Anti-spam Baseline" -AllowedSenderDomains @{Add=$Url}
}